/*******************************/
UDP Sink captures the UDP data
broadcast by the ACU Monitor
(c) 2022 by r2 Scientific
/*******************************/

#pragma once

#pragma pack( push, udpdata, 2 )
typedef struct
{
	int nCameraNumber;
	wchar_t	wszCameraName[32];
	int nX;
	int nY;
	int nW;
	int nH;
	int nPayloadLength;
	double dLevelWeights;
} UDPPACKET, * LPUDPPACKET;
#pragma pack( pop, udpdata )

class CUDPSink
{
public:
	CUDPSink();
	~CUDPSink();
	UCHAR achBuffer[1024];
};

CUDPSink::CUDPSink()
{
	CAESNoWnd* pcAES;
	pcAES = new CAESNoWnd("laterlaterlaterl");
	int i = 0;
	SOCKADDR_IN			stSockAddrIn = { 0 };
	SOCKET				sSocket;
	UDPPACKET			stUDPPacket = { 0 };

	WSADATA stData;
	WSAStartup(MAKEWORD(2, 0), &stData);

	DWORD dwPort = Later;

	// Setup
	stSockAddrIn.sin_family = AF_INET;
	stSockAddrIn.sin_port = htons(dwPort);

	sSocket = NULL;
	sSocket = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
	if (sSocket == SOCKET_ERROR)
		return;

	if (bind(sSocket, (struct sockaddr *)&stSockAddrIn, sizeof(struct sockaddr_in)) == -1)
	{
		DWORD e = GetLastError();
		fprintf(stderr, "Could not bind name to socket.\n");
		closesocket(sSocket);
	}

	unsigned long ulNonBlockingMode = 0;
	if (ioctlsocket(sSocket, FIONBIO, &ulNonBlockingMode))
		return;

	while (true)
	{
		long lLength = recv(sSocket, (char*)achBuffer, 1024, 0);
		if( lLength == 96 )
		{
			i = pcAES->AESDecrypt(achBuffer, lLength, (BYTE*)&stUDPPacket);
			// Do stuff with it
		}
	}
}


